package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.RequerimientoOS3Dao;
import com.ejie.ab04b.model.RequerimientoOS3;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0448s00ServiceImpl generated by UDA, 31-may-2017 9:30:50.
 * 
 * @author UDA
 */

@Service(value = "requerimientoOS3ServiceImpl")
public class RequerimientoOS3ServiceImpl implements RequerimientoOS3Service {

	@Autowired
	private RequerimientoOS3Dao ab0448s00Dao;

	/**
	 * Inserts a single row in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00 Ab0448s00
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @return the requerimiento OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RequerimientoOS3 add(RequerimientoOS3 ab0448s00) {
		return this.ab0448s00Dao.add(ab0448s00);
	}

	/**
	 * Updates a single row in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00 Ab0448s00
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @return the requerimiento OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RequerimientoOS3 update(RequerimientoOS3 ab0448s00) {
		return this.ab0448s00Dao.update(ab0448s00);
	}

	/**
	 * Finds a single row in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00 Ab0448s00
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @return the requerimiento OS 3
	 */
	public RequerimientoOS3 find(RequerimientoOS3 ab0448s00) {
		return (RequerimientoOS3) this.ab0448s00Dao.find(ab0448s00);
	}

	/**
	 * Deletes a single row in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RequerimientoOS3 ab0448s00) {
		this.ab0448s00Dao.remove(ab0448s00);
	}

	/**
	 * Finds a list of rows in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00 jqGridRequestDto JQGridRequestDto List<Ab0448s00>
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<RequerimientoOS3> findAll(RequerimientoOS3 ab0448s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<RequerimientoOS3>) this.ab0448s00Dao.findAll(ab0448s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0448s00 table using like.
	 * 
	 * ab0448s00 Ab0448s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0448s00>
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<RequerimientoOS3> findAllLike(RequerimientoOS3 ab0448s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<RequerimientoOS3>) this.ab0448s00Dao.findAllLike(
				ab0448s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0448s00 table.
	 * 
	 * filterAb0448s00 Ab0448s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean
	 * 
	 * @param filterAb0448s00
	 *            the filter ab 0448 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	public void removeMultiple(RequerimientoOS3 filterAb0448s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab0448s00Dao.removeMultiple(filterAb0448s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Ab0448s00 table.
	 * 
	 * filterAb0448s00 Ab0448s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<Ab0448s00>
	 * 
	 * @param filterAb0448s00
	 *            the filter ab 0448 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<RequerimientoOS3> filter(
			RequerimientoOS3 filterAb0448s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<RequerimientoOS3> listaAb0448s00 = this.ab0448s00Dao.findAllLike(
				filterAb0448s00, jqGridRequestDto, false);
		Long recordNum = this.ab0448s00Dao.findAllLikeCount(
				filterAb0448s00 != null ? filterAb0448s00
						: new RequerimientoOS3(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<RequerimientoOS3>> reorderSelection = this.ab0448s00Dao
					.reorderSelection(filterAb0448s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<RequerimientoOS3>(jqGridRequestDto,
					recordNum, listaAb0448s00, reorderSelection);
		}
		return new JQGridResponseDto<RequerimientoOS3>(jqGridRequestDto,
				recordNum, listaAb0448s00);
	}

	/**
	 * Searches rows in the Ab0448s00 table.
	 * 
	 * filterAb0448s00 Ab0448s00 searchAb0448s00 Ab0448s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0448s00>>
	 * 
	 * @param filterAb0448s00
	 *            the filter ab 0448 s 00
	 * @param searchAb0448s00
	 *            the search ab 0448 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<TableRowDto<RequerimientoOS3>> search(
			RequerimientoOS3 filterAb0448s00, RequerimientoOS3 searchAb0448s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0448s00Dao.search(filterAb0448s00, searchAb0448s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0448s00 table.
	 * 
	 * filterAb0448s00 Ab0448s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean Object
	 * 
	 * @param filterAb0448s00
	 *            the filter ab 0448 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	public Object reorderSelection(RequerimientoOS3 filterAb0448s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0448s00Dao.reorderSelection(filterAb0448s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * removePorTarea
	 * 
	 * @param idTarea
	 *            Long
	 */
	@Override
	public void removePorTarea(Long idTarea) {
		this.ab0448s00Dao.removePorTarea(idTarea);
	}

}
